package io.dingodb.sdk.service.entity.debug;

import io.dingodb.sdk.service.entity.Numeric;

public enum ValueFlag implements Numeric {
    UNRECOGNIZED(-1),

    PUT(0),

    PUT_WITH_TTL(1),

    DELETE(2);

    public final Integer number;

    private Object ext$;

    private ValueFlag(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static ValueFlag forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return PUT;
            case 1: return PUT_WITH_TTL;
            case 2: return DELETE;
            default: return null;
        }
    }
}
