package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@lombok.Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Txn implements Message {
    private List<Lock> locks;

    private List<Data> datas;

    private List<Write> writes;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, datas, (n, v) -> Writer.write(n, v, out));
        Writer.write(2, locks, (n, v) -> Writer.write(n, v, out));
        Writer.write(3, writes, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: datas = Reader.readList(datas, input, in -> Reader.readMessage(new Data(), in)); hasValue = true; break;
                case 2: locks = Reader.readList(locks, input, in -> Reader.readMessage(new Lock(), in)); hasValue = true; break;
                case 3: writes = Reader.readList(writes, input, in -> Reader.readMessage(new Write(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, datas, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, locks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, writes, SizeUtils::sizeOf);
        return size;
    }
}
