package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TsProviderMetrics implements Message {
    private long lastPhysical;

    private long getTsFailCount;

    private long deadCount;

    private long activeCount;

    private long actualActiveCount;

    private long renewEpoch;

    private long actualDeadCount;

    private long getTsCount;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, getTsCount, out);
        Writer.write(2, getTsFailCount, out);
        Writer.write(3, renewEpoch, out);
        Writer.write(4, actualActiveCount, out);
        Writer.write(5, activeCount, out);
        Writer.write(6, actualDeadCount, out);
        Writer.write(7, deadCount, out);
        Writer.write(8, lastPhysical, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: getTsCount = Reader.readLong(input); hasValue = true; break;
                case 2: getTsFailCount = Reader.readLong(input); hasValue = true; break;
                case 3: renewEpoch = Reader.readLong(input); hasValue = true; break;
                case 4: actualActiveCount = Reader.readLong(input); hasValue = true; break;
                case 5: activeCount = Reader.readLong(input); hasValue = true; break;
                case 6: actualDeadCount = Reader.readLong(input); hasValue = true; break;
                case 7: deadCount = Reader.readLong(input); hasValue = true; break;
                case 8: lastPhysical = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, getTsCount);
        size += SizeUtils.sizeOf(2, getTsFailCount);
        size += SizeUtils.sizeOf(3, renewEpoch);
        size += SizeUtils.sizeOf(4, actualActiveCount);
        size += SizeUtils.sizeOf(5, activeCount);
        size += SizeUtils.sizeOf(6, actualDeadCount);
        size += SizeUtils.sizeOf(7, deadCount);
        size += SizeUtils.sizeOf(8, lastPhysical);
        return size;
    }
}
