package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionMetaStat implements Message {
    private Map<String, Integer> stateCounts;

    private int followerCount;

    private int leaderCount;

    private List<Long> leaderRegoinIds;

    private List<Long> followerRegoinIds;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, stateCounts, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(2, leaderCount, out);
        Writer.write(3, leaderRegoinIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(4, followerCount, out);
        Writer.write(5, followerRegoinIds, out, Writer::write, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: stateCounts = Reader.readMap(number, stateCounts, input, Reader::readString, Reader::readInt); hasValue = true; break;
                case 2: leaderCount = Reader.readInt(input); hasValue = true; break;
                case 3: leaderRegoinIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 4: followerCount = Reader.readInt(input); hasValue = true; break;
                case 5: followerRegoinIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, stateCounts, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(2, leaderCount);
        size += SizeUtils.sizeOfPack(3, leaderRegoinIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(4, followerCount);
        size += SizeUtils.sizeOfPack(5, followerRegoinIds, SizeUtils::sizeOf);
        return size;
    }
}
