package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.common.VectorIndexParameter;
import io.dingodb.sdk.service.entity.common.VectorIndexType;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RawVectorIndexState implements Message {
    private long memorySize;

    private RegionEpoch epoch;

    private long applyLogId;

    private String startKey;

    private String endKey;

    private VectorIndexType subType;

    private VectorIndexParameter parameter;

    private long keyCount;

    private long id;

    private long snapshotLogId;

    private long deletedKeyCount;

    private String comment;

    private VectorIndexType type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, type, out);
        Writer.write(3, subType, out);
        Writer.write(10, applyLogId, out);
        Writer.write(11, snapshotLogId, out);
        Writer.write(12, epoch, out);
        Writer.write(20, startKey, out);
        Writer.write(21, endKey, out);
        Writer.write(22, keyCount, out);
        Writer.write(23, deletedKeyCount, out);
        Writer.write(24, memorySize, out);
        Writer.write(30, parameter, out);
        Writer.write(40, comment, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: type = VectorIndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: subType = VectorIndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 10: applyLogId = Reader.readLong(input); hasValue = true; break;
                case 11: snapshotLogId = Reader.readLong(input); hasValue = true; break;
                case 12: epoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : epoch != null; break;
                case 20: startKey = Reader.readString(input); hasValue = true; break;
                case 21: endKey = Reader.readString(input); hasValue = true; break;
                case 22: keyCount = Reader.readLong(input); hasValue = true; break;
                case 23: deletedKeyCount = Reader.readLong(input); hasValue = true; break;
                case 24: memorySize = Reader.readLong(input); hasValue = true; break;
                case 30: parameter = Reader.readMessage(new VectorIndexParameter(), input); hasValue = hasValue ? hasValue : parameter != null; break;
                case 40: comment = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, type);
        size += SizeUtils.sizeOf(3, subType);
        size += SizeUtils.sizeOf(10, applyLogId);
        size += SizeUtils.sizeOf(11, snapshotLogId);
        size += SizeUtils.sizeOf(12, epoch);
        size += SizeUtils.sizeOf(20, startKey);
        size += SizeUtils.sizeOf(21, endKey);
        size += SizeUtils.sizeOf(22, keyCount);
        size += SizeUtils.sizeOf(23, deletedKeyCount);
        size += SizeUtils.sizeOf(24, memorySize);
        size += SizeUtils.sizeOf(30, parameter);
        size += SizeUtils.sizeOf(40, comment);
        return size;
    }
}
