package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.StoreRegionState;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ModifyRegionMetaRequest implements Message, Message.Request {
    private StoreRegionState state;

    private RequestInfo requestInfo;

    private List<String> fields;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, regionId, out);
        Writer.write(10, fields, (n, v) -> Writer.write(n, v, out));
        Writer.write(11, state, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: regionId = Reader.readLong(input); hasValue = true; break;
                case 10: fields = Reader.readList(fields, input, Reader::readString); hasValue = true; break;
                case 11: state = StoreRegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, regionId);
        size += SizeUtils.sizeOf(10, fields, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(11, state);
        return size;
    }
}
