package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class MergeRegionRequest implements Message, Message.Request {
    private long sourceRegionId;

    private RegionEpoch sourceRegionEpoch;

    private RegionEpoch targetRegionEpoch;

    private long targetRegionId;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, sourceRegionId, out);
        Writer.write(3, sourceRegionEpoch, out);
        Writer.write(4, targetRegionId, out);
        Writer.write(5, targetRegionEpoch, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: sourceRegionId = Reader.readLong(input); hasValue = true; break;
                case 3: sourceRegionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : sourceRegionEpoch != null; break;
                case 4: targetRegionId = Reader.readLong(input); hasValue = true; break;
                case 5: targetRegionEpoch = Reader.readMessage(new RegionEpoch(), input); hasValue = hasValue ? hasValue : targetRegionEpoch != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, sourceRegionId);
        size += SizeUtils.sizeOf(3, sourceRegionEpoch);
        size += SizeUtils.sizeOf(4, targetRegionId);
        size += SizeUtils.sizeOf(5, targetRegionEpoch);
        return size;
    }
}
