package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class KV implements Message {
    private ValueFlag flag;

    private long ts;

    private long ttl;

    private byte[] key;

    private byte[] value;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, key, out);
        Writer.write(2, ts, out);
        Writer.write(3, flag, out);
        Writer.write(4, ttl, out);
        Writer.write(5, value, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: key = Reader.readBytes(input); hasValue = true; break;
                case 2: ts = Reader.readLong(input); hasValue = true; break;
                case 3: flag = ValueFlag.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: ttl = Reader.readLong(input); hasValue = true; break;
                case 5: value = Reader.readBytes(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, key);
        size += SizeUtils.sizeOf(2, ts);
        size += SizeUtils.sizeOf(3, flag);
        size += SizeUtils.sizeOf(4, ttl);
        size += SizeUtils.sizeOf(5, value);
        return size;
    }
}
