package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DumpRegionRequest implements Message, Message.Request {
    private long offset;

    private long limit;

    private Range range;

    private RequestInfo requestInfo;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, regionId, out);
        Writer.write(3, range, out);
        Writer.write(10, offset, out);
        Writer.write(11, limit, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: regionId = Reader.readLong(input); hasValue = true; break;
                case 3: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 10: offset = Reader.readLong(input); hasValue = true; break;
                case 11: limit = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, regionId);
        size += SizeUtils.sizeOf(3, range);
        size += SizeUtils.sizeOf(10, offset);
        size += SizeUtils.sizeOf(11, limit);
        return size;
    }
}
