package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Document implements Message {
    private io.dingodb.sdk.service.entity.common.Document document;

    private long documentId;

    private ValueFlag flag;

    private long ts;

    private long ttl;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, documentId, out);
        Writer.write(2, ts, out);
        Writer.write(3, flag, out);
        Writer.write(4, ttl, out);
        Writer.write(10, document, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: documentId = Reader.readLong(input); hasValue = true; break;
                case 2: ts = Reader.readLong(input); hasValue = true; break;
                case 3: flag = ValueFlag.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: ttl = Reader.readLong(input); hasValue = true; break;
                case 10: document = Reader.readMessage(new io.dingodb.sdk.service.entity.common.Document(), input); hasValue = hasValue ? hasValue : document != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, documentId);
        size += SizeUtils.sizeOf(2, ts);
        size += SizeUtils.sizeOf(3, flag);
        size += SizeUtils.sizeOf(4, ttl);
        size += SizeUtils.sizeOf(10, document);
        return size;
    }
}
