package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DebugResponse implements Message, Message.Response {
    private ResponseInfo responseInfo;

    private RegionChange regionChangeRecord;

    private TsProviderMetrics tsProviderMetrics;

    private RaftMeta raftMeta;

    private RegionActualMetrics regionActualMetrics;

    private FileReader fileReader;

    private List<RaftLogMeta> raftLogMetas;

    private RegionMetaStat regionMetaStat;

    private Error error;

    private RegionMetaDetails regionMetaDetails;

    private DocumentIndexMetrics documentIndexMetrics;

    private RegionExecutor regionExecutor;

    private VectorIndexMetrics vectorIndexMetrics;

    private RegionControlCommand regionControlCommand;

    private StoreMetrics storeMetrics;

    private RegionMetrics regionMetrics;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(10, regionMetaStat, out);
        Writer.write(11, regionMetaDetails, out);
        Writer.write(12, regionControlCommand, out);
        Writer.write(13, raftMeta, out);
        Writer.write(14, regionExecutor, out);
        Writer.write(15, regionMetrics, out);
        Writer.write(16, fileReader, out);
        Writer.write(17, regionActualMetrics, out);
        Writer.write(18, storeMetrics, out);
        Writer.write(19, regionChangeRecord, out);
        Writer.write(20, vectorIndexMetrics, out);
        Writer.write(21, tsProviderMetrics, out);
        Writer.write(22, documentIndexMetrics, out);
        Writer.write(23, raftLogMetas, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 10: regionMetaStat = Reader.readMessage(new RegionMetaStat(), input); hasValue = hasValue ? hasValue : regionMetaStat != null; break;
                case 11: regionMetaDetails = Reader.readMessage(new RegionMetaDetails(), input); hasValue = hasValue ? hasValue : regionMetaDetails != null; break;
                case 12: regionControlCommand = Reader.readMessage(new RegionControlCommand(), input); hasValue = hasValue ? hasValue : regionControlCommand != null; break;
                case 13: raftMeta = Reader.readMessage(new RaftMeta(), input); hasValue = hasValue ? hasValue : raftMeta != null; break;
                case 14: regionExecutor = Reader.readMessage(new RegionExecutor(), input); hasValue = hasValue ? hasValue : regionExecutor != null; break;
                case 15: regionMetrics = Reader.readMessage(new RegionMetrics(), input); hasValue = hasValue ? hasValue : regionMetrics != null; break;
                case 16: fileReader = Reader.readMessage(new FileReader(), input); hasValue = hasValue ? hasValue : fileReader != null; break;
                case 17: regionActualMetrics = Reader.readMessage(new RegionActualMetrics(), input); hasValue = hasValue ? hasValue : regionActualMetrics != null; break;
                case 18: storeMetrics = Reader.readMessage(new StoreMetrics(), input); hasValue = hasValue ? hasValue : storeMetrics != null; break;
                case 19: regionChangeRecord = Reader.readMessage(new RegionChange(), input); hasValue = hasValue ? hasValue : regionChangeRecord != null; break;
                case 20: vectorIndexMetrics = Reader.readMessage(new VectorIndexMetrics(), input); hasValue = hasValue ? hasValue : vectorIndexMetrics != null; break;
                case 21: tsProviderMetrics = Reader.readMessage(new TsProviderMetrics(), input); hasValue = hasValue ? hasValue : tsProviderMetrics != null; break;
                case 22: documentIndexMetrics = Reader.readMessage(new DocumentIndexMetrics(), input); hasValue = hasValue ? hasValue : documentIndexMetrics != null; break;
                case 23: raftLogMetas = Reader.readList(raftLogMetas, input, in -> Reader.readMessage(new RaftLogMeta(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(10, regionMetaStat);
        size += SizeUtils.sizeOf(11, regionMetaDetails);
        size += SizeUtils.sizeOf(12, regionControlCommand);
        size += SizeUtils.sizeOf(13, raftMeta);
        size += SizeUtils.sizeOf(14, regionExecutor);
        size += SizeUtils.sizeOf(15, regionMetrics);
        size += SizeUtils.sizeOf(16, fileReader);
        size += SizeUtils.sizeOf(17, regionActualMetrics);
        size += SizeUtils.sizeOf(18, storeMetrics);
        size += SizeUtils.sizeOf(19, regionChangeRecord);
        size += SizeUtils.sizeOf(20, vectorIndexMetrics);
        size += SizeUtils.sizeOf(21, tsProviderMetrics);
        size += SizeUtils.sizeOf(22, documentIndexMetrics);
        size += SizeUtils.sizeOf(23, raftLogMetas, SizeUtils::sizeOf);
        return size;
    }
}
