package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DebugRequest implements Message, Message.Request {
    private boolean isActual;

    private RequestInfo requestInfo;

    private List<Long> regionIds;

    private DebugType type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, type, out);
        Writer.write(3, regionIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(8, isActual, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: type = DebugType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: regionIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 8: isActual = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, type);
        size += SizeUtils.sizeOfPack(3, regionIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(8, isActual);
        return size;
    }
}
