package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@lombok.Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Data implements Message {
    private Txn txn;

    private List<KV> kvs;

    private List<Document> documents;

    private List<Vector> vectors;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(100, kvs, (n, v) -> Writer.write(n, v, out));
        Writer.write(101, vectors, (n, v) -> Writer.write(n, v, out));
        Writer.write(102, documents, (n, v) -> Writer.write(n, v, out));
        Writer.write(200, txn, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 100: kvs = Reader.readList(kvs, input, in -> Reader.readMessage(new KV(), in)); hasValue = true; break;
                case 101: vectors = Reader.readList(vectors, input, in -> Reader.readMessage(new Vector(), in)); hasValue = true; break;
                case 102: documents = Reader.readList(documents, input, in -> Reader.readMessage(new Document(), in)); hasValue = true; break;
                case 200: txn = Reader.readMessage(new Txn(), input); hasValue = hasValue ? hasValue : txn != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(100, kvs, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(101, vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(102, documents, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(200, txn);
        return size;
    }
}
