package io.dingodb.sdk.service.entity.debug;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class BindCoreRequest implements Message, Message.Request {
    private List<Integer> threads;

    private RequestInfo requestInfo;

    private String threadPoolName;

    private List<Integer> cores;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(10, threadPoolName, out);
        Writer.write(11, threads, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(12, cores, out, Writer::write, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 10: threadPoolName = Reader.readString(input); hasValue = true; break;
                case 11: threads = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                case 12: cores = Reader.readPack(input, Reader::readInt); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(10, threadPoolName);
        size += SizeUtils.sizeOfPack(11, threads, SizeUtils::sizeOf);
        size += SizeUtils.sizeOfPack(12, cores, SizeUtils::sizeOf);
        return size;
    }
}
