package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.StoreInState;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class UpdateStoreRequest implements Message, Message.Request {
    private long clusterId;

    private String keyring;

    private RequestInfo requestInfo;

    private long storeId;

    private StoreInState storeInState;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, clusterId, out);
        Writer.write(3, storeId, out);
        Writer.write(4, keyring, out);
        Writer.write(5, storeInState, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: clusterId = Reader.readLong(input); hasValue = true; break;
                case 3: storeId = Reader.readLong(input); hasValue = true; break;
                case 4: keyring = Reader.readString(input); hasValue = true; break;
                case 5: storeInState = StoreInState.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, clusterId);
        size += SizeUtils.sizeOf(3, storeId);
        size += SizeUtils.sizeOf(4, keyring);
        size += SizeUtils.sizeOf(5, storeInState);
        return size;
    }
}
