package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.error.Error;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class UpdateRegionCmdStatusRequest implements Message, Message.Request {
    private Error error;

    private long jobId;

    private long regionCmdId;

    private RegionCmdStatus status;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, jobId, out);
        Writer.write(3, regionCmdId, out);
        Writer.write(4, status, out);
        Writer.write(5, error, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: jobId = Reader.readLong(input); hasValue = true; break;
                case 3: regionCmdId = Reader.readLong(input); hasValue = true; break;
                case 4: status = RegionCmdStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, jobId);
        size += SizeUtils.sizeOf(3, regionCmdId);
        size += SizeUtils.sizeOf(4, status);
        size += SizeUtils.sizeOf(5, error);
        return size;
    }
}
