package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class UpdateGCSafePointRequest implements Message, Message.Request {
    private Map<Long, Long> tenantSafePoints;

    private long resolveLockSafePoint;

    private RequestInfo requestInfo;

    private GcFlagType gcFlag;

    private Map<Long, Long> tenantResolveLockSafePoints;

    private long safePoint;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, safePoint, out);
        Writer.write(3, gcFlag, out);
        Writer.write(4, resolveLockSafePoint, out);
        Writer.write(5, tenantSafePoints, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(6, tenantResolveLockSafePoints, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: safePoint = Reader.readLong(input); hasValue = true; break;
                case 3: gcFlag = GcFlagType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: resolveLockSafePoint = Reader.readLong(input); hasValue = true; break;
                case 5: tenantSafePoints = Reader.readMap(number, tenantSafePoints, input, Reader::readLong, Reader::readLong); hasValue = true; break;
                case 6: tenantResolveLockSafePoints = Reader.readMap(number, tenantResolveLockSafePoints, input, Reader::readLong, Reader::readLong); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, safePoint);
        size += SizeUtils.sizeOf(3, gcFlag);
        size += SizeUtils.sizeOf(4, resolveLockSafePoint);
        size += SizeUtils.sizeOf(5, tenantSafePoints, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, tenantResolveLockSafePoints, SizeUtils::sizeOf, SizeUtils::sizeOf);
        return size;
    }
}
