package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class TaskPreCheck implements Message {
    private PreCheckNest preCheck;

    private TaskPreCheckType type;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, type, out);
        Writer.write(preCheck, preCheck, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: type = TaskPreCheckType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: preCheck = Reader.readMessage(new PreCheckNest.RegionCheck(), input); hasValue = hasValue ? hasValue : preCheck != null; break;
                case 3: preCheck = Reader.readMessage(new PreCheckNest.StoreRegionCheck(), input); hasValue = hasValue ? hasValue : preCheck != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, type);
        size += SizeUtils.sizeOf(preCheck, preCheck);
        return size;
    }

    public interface PreCheckNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class RegionCheck extends io.dingodb.sdk.service.entity.coordinator.RegionCheck implements PreCheckNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.REGION_CHECK;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class StoreRegionCheck extends io.dingodb.sdk.service.entity.coordinator.StoreRegionCheck implements PreCheckNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.STORE_REGION_CHECK;
            }
        }

        enum Nest implements Numeric {
            REGION_CHECK(2),

            STORE_REGION_CHECK(3);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
