package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Task implements Message {
    private int step;

    private List<CoordinatorOperation> coordinatorOperations;

    private List<StoreOperation> storeOperations;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, step, out);
        Writer.write(2, storeOperations, (n, v) -> Writer.write(n, v, out));
        Writer.write(3, coordinatorOperations, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: step = Reader.readInt(input); hasValue = true; break;
                case 2: storeOperations = Reader.readList(storeOperations, input, in -> Reader.readMessage(new StoreOperation(), in)); hasValue = true; break;
                case 3: coordinatorOperations = Reader.readList(coordinatorOperations, input, in -> Reader.readMessage(new CoordinatorOperation(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, step);
        size += SizeUtils.sizeOf(2, storeOperations, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, coordinatorOperations, SizeUtils::sizeOf);
        return size;
    }
}
