package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Peer;
import io.dingodb.sdk.service.entity.common.RaftNodeState;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.StoreRegionState;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StoreRegionCheck implements Message {
    private boolean checkVectorIndexIsReady;

    private StoreRegionState storeRegionState;

    private long vectorIndexVersion;

    private boolean isReady;

    private boolean isHoldVectorIndex;

    private Range range;

    private long storeId;

    private RaftNodeState raftNodeStatus;

    private boolean checkVectorIndexIsHold;

    private List<Peer> peers;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, storeId, out);
        Writer.write(2, regionId, out);
        Writer.write(3, range, out);
        Writer.write(4, storeRegionState, out);
        Writer.write(5, raftNodeStatus, out);
        Writer.write(6, peers, (n, v) -> Writer.write(n, v, out));
        Writer.write(7, checkVectorIndexIsHold, out);
        Writer.write(8, isHoldVectorIndex, out);
        Writer.write(9, checkVectorIndexIsReady, out);
        Writer.write(10, isReady, out);
        Writer.write(11, vectorIndexVersion, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: storeId = Reader.readLong(input); hasValue = true; break;
                case 2: regionId = Reader.readLong(input); hasValue = true; break;
                case 3: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 4: storeRegionState = StoreRegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: raftNodeStatus = RaftNodeState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 6: peers = Reader.readList(peers, input, in -> Reader.readMessage(new Peer(), in)); hasValue = true; break;
                case 7: checkVectorIndexIsHold = Reader.readBoolean(input); hasValue = true; break;
                case 8: isHoldVectorIndex = Reader.readBoolean(input); hasValue = true; break;
                case 9: checkVectorIndexIsReady = Reader.readBoolean(input); hasValue = true; break;
                case 10: isReady = Reader.readBoolean(input); hasValue = true; break;
                case 11: vectorIndexVersion = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, storeId);
        size += SizeUtils.sizeOf(2, regionId);
        size += SizeUtils.sizeOf(3, range);
        size += SizeUtils.sizeOf(4, storeRegionState);
        size += SizeUtils.sizeOf(5, raftNodeStatus);
        size += SizeUtils.sizeOf(6, peers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(7, checkVectorIndexIsHold);
        size += SizeUtils.sizeOf(8, isHoldVectorIndex);
        size += SizeUtils.sizeOf(9, checkVectorIndexIsReady);
        size += SizeUtils.sizeOf(10, isReady);
        size += SizeUtils.sizeOf(11, vectorIndexVersion);
        return size;
    }
}
