package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class StoreOperation implements Message {
    private List<Error> errors;

    private TaskPreCheck preCheck;

    private boolean isSuccess;

    private List<RegionCmd> regionCmds;

    private long storeId;

    private int retryCount;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, storeId, out);
        Writer.write(2, regionCmds, (n, v) -> Writer.write(n, v, out));
        Writer.write(3, preCheck, out);
        Writer.write(4, retryCount, out);
        Writer.write(5, errors, (n, v) -> Writer.write(n, v, out));
        Writer.write(6, isSuccess, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: storeId = Reader.readLong(input); hasValue = true; break;
                case 2: regionCmds = Reader.readList(regionCmds, input, in -> Reader.readMessage(new RegionCmd(), in)); hasValue = true; break;
                case 3: preCheck = Reader.readMessage(new TaskPreCheck(), input); hasValue = hasValue ? hasValue : preCheck != null; break;
                case 4: retryCount = Reader.readInt(input); hasValue = true; break;
                case 5: errors = Reader.readList(errors, input, in -> Reader.readMessage(new Error(), in)); hasValue = true; break;
                case 6: isSuccess = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, storeId);
        size += SizeUtils.sizeOf(2, regionCmds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, preCheck);
        size += SizeUtils.sizeOf(4, retryCount);
        size += SizeUtils.sizeOf(5, errors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, isSuccess);
        return size;
    }
}
