package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegisterRestoreRequest implements Message, Message.Request {
    private String restorePath;

    private String restoreName;

    private RequestInfo requestInfo;

    private long restoreCurrentTimestamp;

    private long restoreStartTimestamp;

    private long restoreTimeoutS;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, restoreName, out);
        Writer.write(3, restorePath, out);
        Writer.write(4, restoreStartTimestamp, out);
        Writer.write(5, restoreCurrentTimestamp, out);
        Writer.write(6, restoreTimeoutS, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: restoreName = Reader.readString(input); hasValue = true; break;
                case 3: restorePath = Reader.readString(input); hasValue = true; break;
                case 4: restoreStartTimestamp = Reader.readLong(input); hasValue = true; break;
                case 5: restoreCurrentTimestamp = Reader.readLong(input); hasValue = true; break;
                case 6: restoreTimeoutS = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, restoreName);
        size += SizeUtils.sizeOf(3, restorePath);
        size += SizeUtils.sizeOf(4, restoreStartTimestamp);
        size += SizeUtils.sizeOf(5, restoreCurrentTimestamp);
        size += SizeUtils.sizeOf(6, restoreTimeoutS);
        return size;
    }
}
