package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegisterBackupRequest implements Message, Message.Request {
    private long backupStartTimestamp;

    private long backupCurrentTimestamp;

    private RequestInfo requestInfo;

    private String backupName;

    private String backupPath;

    private long backupTimeoutS;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, backupName, out);
        Writer.write(3, backupPath, out);
        Writer.write(4, backupStartTimestamp, out);
        Writer.write(5, backupCurrentTimestamp, out);
        Writer.write(6, backupTimeoutS, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: backupName = Reader.readString(input); hasValue = true; break;
                case 3: backupPath = Reader.readString(input); hasValue = true; break;
                case 4: backupStartTimestamp = Reader.readLong(input); hasValue = true; break;
                case 5: backupCurrentTimestamp = Reader.readLong(input); hasValue = true; break;
                case 6: backupTimeoutS = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, backupName);
        size += SizeUtils.sizeOf(3, backupPath);
        size += SizeUtils.sizeOf(4, backupStartTimestamp);
        size += SizeUtils.sizeOf(5, backupCurrentTimestamp);
        size += SizeUtils.sizeOf(6, backupTimeoutS);
        return size;
    }
}
