package io.dingodb.sdk.service.entity.coordinator;

import io.dingodb.sdk.service.entity.Numeric;

public enum RegionCmdStatus implements Numeric {
    UNRECOGNIZED(-1),

    STATUS_NONE(0),

    STATUS_DONE(1),

    STATUS_FAIL(2);

    public final Integer number;

    private Object ext$;

    private RegionCmdStatus(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static RegionCmdStatus forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return STATUS_NONE;
            case 1: return STATUS_DONE;
            case 2: return STATUS_FAIL;
            default: return null;
        }
    }
}
