package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import io.dingodb.sdk.service.entity.error.Error;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionCmd implements Message {
    private RegionCmdType regionCmdType;

    private RequestNest request;

    private RegionCmdStatus status;

    private long storeId;

    private long regionId;

    private Error error;

    private long jobId;

    private long createTimestamp;

    private long id;

    private boolean isNotify;

    private boolean retry;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, jobId, out);
        Writer.write(3, regionId, out);
        Writer.write(4, regionCmdType, out);
        Writer.write(5, createTimestamp, out);
        Writer.write(6, storeId, out);
        Writer.write(request, request, out);
        Writer.write(40, isNotify, out);
        Writer.write(50, status, out);
        Writer.write(51, error, out);
        Writer.write(52, retry, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: jobId = Reader.readLong(input); hasValue = true; break;
                case 3: regionId = Reader.readLong(input); hasValue = true; break;
                case 4: regionCmdType = RegionCmdType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: createTimestamp = Reader.readLong(input); hasValue = true; break;
                case 6: storeId = Reader.readLong(input); hasValue = true; break;
                case 11: request = Reader.readMessage(new RequestNest.CreateRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 12: request = Reader.readMessage(new RequestNest.DeleteRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 13: request = Reader.readMessage(new RequestNest.SplitRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 14: request = Reader.readMessage(new RequestNest.MergeRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 15: request = Reader.readMessage(new RequestNest.ChangePeerRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 16: request = Reader.readMessage(new RequestNest.PurgeRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 17: request = Reader.readMessage(new RequestNest.TransferLeaderRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 18: request = Reader.readMessage(new RequestNest.SnapshotVectorIndexRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 19: request = Reader.readMessage(new RequestNest.UpdateDefinitionRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 20: request = Reader.readMessage(new RequestNest.SwitchSplitRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 21: request = Reader.readMessage(new RequestNest.HoldVectorIndexRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 30: request = Reader.readMessage(new RequestNest.StopRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 31: request = Reader.readMessage(new RequestNest.DestroyExecutorRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 32: request = Reader.readMessage(new RequestNest.DeleteDataRequest(), input); hasValue = hasValue ? hasValue : request != null; break;
                case 40: isNotify = Reader.readBoolean(input); hasValue = true; break;
                case 50: status = RegionCmdStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 51: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 52: retry = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, jobId);
        size += SizeUtils.sizeOf(3, regionId);
        size += SizeUtils.sizeOf(4, regionCmdType);
        size += SizeUtils.sizeOf(5, createTimestamp);
        size += SizeUtils.sizeOf(6, storeId);
        size += SizeUtils.sizeOf(request, request);
        size += SizeUtils.sizeOf(40, isNotify);
        size += SizeUtils.sizeOf(50, status);
        size += SizeUtils.sizeOf(51, error);
        size += SizeUtils.sizeOf(52, retry);
        return size;
    }

    public interface RequestNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class CreateRequest extends io.dingodb.sdk.service.entity.coordinator.CreateRequest implements RequestNest {
            public static final int number = 11;

            @Override
            public int number() {
                return 11;
            }

            @Override
            public Nest nest() {
                return Nest.CREATE_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class DeleteRequest extends io.dingodb.sdk.service.entity.coordinator.DeleteRequest implements RequestNest {
            public static final int number = 12;

            @Override
            public int number() {
                return 12;
            }

            @Override
            public Nest nest() {
                return Nest.DELETE_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class SplitRequest extends io.dingodb.sdk.service.entity.coordinator.SplitRequest implements RequestNest {
            public static final int number = 13;

            @Override
            public int number() {
                return 13;
            }

            @Override
            public Nest nest() {
                return Nest.SPLIT_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class MergeRequest extends io.dingodb.sdk.service.entity.coordinator.MergeRequest implements RequestNest {
            public static final int number = 14;

            @Override
            public int number() {
                return 14;
            }

            @Override
            public Nest nest() {
                return Nest.MERGE_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class ChangePeerRequest extends io.dingodb.sdk.service.entity.coordinator.ChangePeerRequest implements RequestNest {
            public static final int number = 15;

            @Override
            public int number() {
                return 15;
            }

            @Override
            public Nest nest() {
                return Nest.CHANGE_PEER_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class PurgeRequest extends io.dingodb.sdk.service.entity.coordinator.PurgeRequest implements RequestNest {
            public static final int number = 16;

            @Override
            public int number() {
                return 16;
            }

            @Override
            public Nest nest() {
                return Nest.PURGE_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class TransferLeaderRequest extends io.dingodb.sdk.service.entity.coordinator.TransferLeaderRequest implements RequestNest {
            public static final int number = 17;

            @Override
            public int number() {
                return 17;
            }

            @Override
            public Nest nest() {
                return Nest.TRANSFER_LEADER_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class SnapshotVectorIndexRequest extends io.dingodb.sdk.service.entity.coordinator.SnapshotVectorIndexRequest implements RequestNest {
            public static final int number = 18;

            @Override
            public int number() {
                return 18;
            }

            @Override
            public Nest nest() {
                return Nest.SNAPSHOT_VECTOR_INDEX_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class UpdateDefinitionRequest extends io.dingodb.sdk.service.entity.coordinator.UpdateDefinitionRequest implements RequestNest {
            public static final int number = 19;

            @Override
            public int number() {
                return 19;
            }

            @Override
            public Nest nest() {
                return Nest.UPDATE_DEFINITION_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class SwitchSplitRequest extends io.dingodb.sdk.service.entity.coordinator.SwitchSplitRequest implements RequestNest {
            public static final int number = 20;

            @Override
            public int number() {
                return 20;
            }

            @Override
            public Nest nest() {
                return Nest.SWITCH_SPLIT_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class HoldVectorIndexRequest extends io.dingodb.sdk.service.entity.coordinator.HoldVectorIndexRequest implements RequestNest {
            public static final int number = 21;

            @Override
            public int number() {
                return 21;
            }

            @Override
            public Nest nest() {
                return Nest.HOLD_VECTOR_INDEX_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class StopRequest extends io.dingodb.sdk.service.entity.coordinator.StopRequest implements RequestNest {
            public static final int number = 30;

            @Override
            public int number() {
                return 30;
            }

            @Override
            public Nest nest() {
                return Nest.STOP_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class DestroyExecutorRequest extends io.dingodb.sdk.service.entity.coordinator.DestroyExecutorRequest implements RequestNest {
            public static final int number = 31;

            @Override
            public int number() {
                return 31;
            }

            @Override
            public Nest nest() {
                return Nest.DESTROY_EXECUTOR_REQUEST;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class DeleteDataRequest extends io.dingodb.sdk.service.entity.coordinator.DeleteDataRequest implements RequestNest {
            public static final int number = 32;

            @Override
            public int number() {
                return 32;
            }

            @Override
            public Nest nest() {
                return Nest.DELETE_DATA_REQUEST;
            }
        }

        enum Nest implements Numeric {
            CREATE_REQUEST(11),

            DELETE_REQUEST(12),

            SPLIT_REQUEST(13),

            MERGE_REQUEST(14),

            CHANGE_PEER_REQUEST(15),

            PURGE_REQUEST(16),

            TRANSFER_LEADER_REQUEST(17),

            SNAPSHOT_VECTOR_INDEX_REQUEST(18),

            UPDATE_DEFINITION_REQUEST(19),

            SWITCH_SPLIT_REQUEST(20),

            HOLD_VECTOR_INDEX_REQUEST(21),

            STOP_REQUEST(30),

            DESTROY_EXECUTOR_REQUEST(31),

            DELETE_DATA_REQUEST(32);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
