package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Peer;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionRaftStatus;
import io.dingodb.sdk.service.entity.common.RegionState;
import io.dingodb.sdk.service.entity.common.ReplicaStatus;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RegionCheck implements Message {
    private RegionState state;

    private RegionRaftStatus raftStatus;

    private long vectorSnapshotLogId;

    private Range range;

    private ReplicaStatus replicaStatus;

    private List<Peer> peers;

    private long regionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, regionId, out);
        Writer.write(2, range, out);
        Writer.write(3, state, out);
        Writer.write(4, raftStatus, out);
        Writer.write(5, replicaStatus, out);
        Writer.write(6, peers, (n, v) -> Writer.write(n, v, out));
        Writer.write(12, vectorSnapshotLogId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: regionId = Reader.readLong(input); hasValue = true; break;
                case 2: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 3: state = RegionState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: raftStatus = RegionRaftStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 5: replicaStatus = ReplicaStatus.forNumber(Reader.readInt(input));hasValue = true; break;
                case 6: peers = Reader.readList(peers, input, in -> Reader.readMessage(new Peer(), in)); hasValue = true; break;
                case 12: vectorSnapshotLogId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, regionId);
        size += SizeUtils.sizeOf(2, range);
        size += SizeUtils.sizeOf(3, state);
        size += SizeUtils.sizeOf(4, raftStatus);
        size += SizeUtils.sizeOf(5, replicaStatus);
        size += SizeUtils.sizeOf(6, peers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(12, vectorSnapshotLogId);
        return size;
    }
}
