package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class RaftControlRequest implements Message, Message.Request {
    private boolean force;

    private RaftControlNodeIndex nodeIndex;

    private String removePeer;

    private String newLeader;

    private RaftControlOp opType;

    private RequestInfo requestInfo;

    private String addPeer;

    private long electionTime;

    private List<String> newPeers;

    private List<String> oldPeers;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, opType, out);
        Writer.write(3, nodeIndex, out);
        Writer.write(4, newLeader, out);
        Writer.write(5, addPeer, out);
        Writer.write(6, removePeer, out);
        Writer.write(7, oldPeers, (n, v) -> Writer.write(n, v, out));
        Writer.write(8, newPeers, (n, v) -> Writer.write(n, v, out));
        Writer.write(9, electionTime, out);
        Writer.write(10, force, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: opType = RaftControlOp.forNumber(Reader.readInt(input));hasValue = true; break;
                case 3: nodeIndex = RaftControlNodeIndex.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: newLeader = Reader.readString(input); hasValue = true; break;
                case 5: addPeer = Reader.readString(input); hasValue = true; break;
                case 6: removePeer = Reader.readString(input); hasValue = true; break;
                case 7: oldPeers = Reader.readList(oldPeers, input, Reader::readString); hasValue = true; break;
                case 8: newPeers = Reader.readList(newPeers, input, Reader::readString); hasValue = true; break;
                case 9: electionTime = Reader.readLong(input); hasValue = true; break;
                case 10: force = Reader.readBoolean(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, opType);
        size += SizeUtils.sizeOf(3, nodeIndex);
        size += SizeUtils.sizeOf(4, newLeader);
        size += SizeUtils.sizeOf(5, addPeer);
        size += SizeUtils.sizeOf(6, removePeer);
        size += SizeUtils.sizeOf(7, oldPeers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(8, newPeers, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(9, electionTime);
        size += SizeUtils.sizeOf(10, force);
        return size;
    }
}
