package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class Job implements Message {
    private long nextStep;

    private String name;

    private long id;

    private String status;

    private String updateTime;

    private String createTime;

    private String finishTime;

    private List<Task> tasks;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, name, out);
        Writer.write(3, nextStep, out);
        Writer.write(4, tasks, (n, v) -> Writer.write(n, v, out));
        Writer.write(10, createTime, out);
        Writer.write(11, finishTime, out);
        Writer.write(12, updateTime, out);
        Writer.write(13, status, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: name = Reader.readString(input); hasValue = true; break;
                case 3: nextStep = Reader.readLong(input); hasValue = true; break;
                case 4: tasks = Reader.readList(tasks, input, in -> Reader.readMessage(new Task(), in)); hasValue = true; break;
                case 10: createTime = Reader.readString(input); hasValue = true; break;
                case 11: finishTime = Reader.readString(input); hasValue = true; break;
                case 12: updateTime = Reader.readString(input); hasValue = true; break;
                case 13: status = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, name);
        size += SizeUtils.sizeOf(3, nextStep);
        size += SizeUtils.sizeOf(4, tasks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(10, createTime);
        size += SizeUtils.sizeOf(11, finishTime);
        size += SizeUtils.sizeOf(12, updateTime);
        size += SizeUtils.sizeOf(13, status);
        return size;
    }
}
