package io.dingodb.sdk.service.entity.coordinator;

import io.dingodb.sdk.service.entity.Numeric;

public enum IdEpochType implements Numeric {
    UNRECOGNIZED(-1),

    ID_NONE(0),

    ID_NEXT_COORINATOR(1),

    ID_NEXT_STORE(2),

    ID_NEXT_EXECUTOR(3),

    ID_NEXT_SCHEMA(4),

    ID_NEXT_REGION(5),

    ID_NEXT_TABLE(6),

    ID_NEXT_INDEX(7),

    ID_NEXT_TENANT(8),

    EPOCH_COORINATOR(11),

    EPOCH_STORE(12),

    EPOCH_EXECUTOR(13),

    EPOCH_SCHEMA(14),

    EPOCH_REGION(15),

    EPOCH_TABLE(16),

    EPOCH_INDEX(17),

    EPOCH_MDS(18),

    RAFT_APPLY_TERM(21),

    RAFT_APPLY_INDEX(22),

    ID_NEXT_REGION_CMD(31),

    ID_NEXT_JOB(32),

    ID_NEXT_LEASE(40),

    ID_NEXT_REVISION(41),

    ID_NEXT_META_WATCH(42),

    ID_GC_SAFE_POINT(50),

    ID_SCHEMA_VERSION(51),

    ID_DDL_JOB(52),

    ID_GC_RESOLVE_LOCK_SAFE_POINT(53);

    public final Integer number;

    private Object ext$;

    private IdEpochType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static IdEpochType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return ID_NONE;
            case 1: return ID_NEXT_COORINATOR;
            case 2: return ID_NEXT_STORE;
            case 3: return ID_NEXT_EXECUTOR;
            case 4: return ID_NEXT_SCHEMA;
            case 5: return ID_NEXT_REGION;
            case 6: return ID_NEXT_TABLE;
            case 7: return ID_NEXT_INDEX;
            case 8: return ID_NEXT_TENANT;
            case 11: return EPOCH_COORINATOR;
            case 12: return EPOCH_STORE;
            case 13: return EPOCH_EXECUTOR;
            case 14: return EPOCH_SCHEMA;
            case 15: return EPOCH_REGION;
            case 16: return EPOCH_TABLE;
            case 17: return EPOCH_INDEX;
            case 18: return EPOCH_MDS;
            case 21: return RAFT_APPLY_TERM;
            case 22: return RAFT_APPLY_INDEX;
            case 31: return ID_NEXT_REGION_CMD;
            case 32: return ID_NEXT_JOB;
            case 40: return ID_NEXT_LEASE;
            case 41: return ID_NEXT_REVISION;
            case 42: return ID_NEXT_META_WATCH;
            case 50: return ID_GC_SAFE_POINT;
            case 51: return ID_SCHEMA_VERSION;
            case 52: return ID_DDL_JOB;
            case 53: return ID_GC_RESOLVE_LOCK_SAFE_POINT;
            default: return null;
        }
    }
}
