package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.CoordinatorState;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.common.VersionInfo;
import io.dingodb.sdk.service.entity.error.Error;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class HelloResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private String statusDetail;

    private CoordinatorState state;

    private CoordinatorMemoryInfo memoryInfo;

    private ClusterState clusterState;

    private VersionInfo versionInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, state, out);
        Writer.write(4, statusDetail, out);
        Writer.write(5, memoryInfo, out);
        Writer.write(6, clusterState, out);
        Writer.write(7, versionInfo, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: state = CoordinatorState.forNumber(Reader.readInt(input));hasValue = true; break;
                case 4: statusDetail = Reader.readString(input); hasValue = true; break;
                case 5: memoryInfo = Reader.readMessage(new CoordinatorMemoryInfo(), input); hasValue = hasValue ? hasValue : memoryInfo != null; break;
                case 6: clusterState = Reader.readMessage(new ClusterState(), input); hasValue = hasValue ? hasValue : clusterState != null; break;
                case 7: versionInfo = Reader.readMessage(new VersionInfo(), input); hasValue = hasValue ? hasValue : versionInfo != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, state);
        size += SizeUtils.sizeOf(4, statusDetail);
        size += SizeUtils.sizeOf(5, memoryInfo);
        size += SizeUtils.sizeOf(6, clusterState);
        size += SizeUtils.sizeOf(7, versionInfo);
        return size;
    }
}
