package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class GetJobListRequest implements Message, Message.Request {
    private int archiveLimit;

    private long jobId;

    private boolean includeArchive;

    private long clusterId;

    private boolean getJobIdOnly;

    private RequestInfo requestInfo;

    private long archiveStartId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, clusterId, out);
        Writer.write(3, jobId, out);
        Writer.write(4, getJobIdOnly, out);
        Writer.write(5, includeArchive, out);
        Writer.write(6, archiveStartId, out);
        Writer.write(7, archiveLimit, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: clusterId = Reader.readLong(input); hasValue = true; break;
                case 3: jobId = Reader.readLong(input); hasValue = true; break;
                case 4: getJobIdOnly = Reader.readBoolean(input); hasValue = true; break;
                case 5: includeArchive = Reader.readBoolean(input); hasValue = true; break;
                case 6: archiveStartId = Reader.readLong(input); hasValue = true; break;
                case 7: archiveLimit = Reader.readInt(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, clusterId);
        size += SizeUtils.sizeOf(3, jobId);
        size += SizeUtils.sizeOf(4, getJobIdOnly);
        size += SizeUtils.sizeOf(5, includeArchive);
        size += SizeUtils.sizeOf(6, archiveStartId);
        size += SizeUtils.sizeOf(7, archiveLimit);
        return size;
    }
}
