package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.Map;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class GetGCSafePointResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private Map<Long, Long> tenantSafePoints;

    private long resolveLockSafePoint;

    private Map<Long, Long> tenantResolveLockSafePoints;

    private long safePoint;

    private boolean gcStop;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, safePoint, out);
        Writer.write(4, gcStop, out);
        Writer.write(5, tenantSafePoints, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write(6, resolveLockSafePoint, out);
        Writer.write(7, tenantResolveLockSafePoints, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: safePoint = Reader.readLong(input); hasValue = true; break;
                case 4: gcStop = Reader.readBoolean(input); hasValue = true; break;
                case 5: tenantSafePoints = Reader.readMap(number, tenantSafePoints, input, Reader::readLong, Reader::readLong); hasValue = true; break;
                case 6: resolveLockSafePoint = Reader.readLong(input); hasValue = true; break;
                case 7: tenantResolveLockSafePoints = Reader.readMap(number, tenantResolveLockSafePoints, input, Reader::readLong, Reader::readLong); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, safePoint);
        size += SizeUtils.sizeOf(4, gcStop);
        size += SizeUtils.sizeOf(5, tenantSafePoints, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(6, resolveLockSafePoint);
        size += SizeUtils.sizeOf(7, tenantResolveLockSafePoints, SizeUtils::sizeOf, SizeUtils::sizeOf);
        return size;
    }
}
