package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class GetGCSafePointRequest implements Message, Message.Request {
    private List<Long> tenantIds;

    private boolean getAllTenant;

    private List<Long> tenantResolveLockIds;

    private RequestInfo requestInfo;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, tenantIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(3, getAllTenant, out);
        Writer.write(4, tenantResolveLockIds, out, Writer::write, SizeUtils::sizeOf);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: tenantIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 3: getAllTenant = Reader.readBoolean(input); hasValue = true; break;
                case 4: tenantResolveLockIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOfPack(2, tenantIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, getAllTenant);
        size += SizeUtils.sizeOfPack(4, tenantResolveLockIds, SizeUtils::sizeOf);
        return size;
    }
}
