package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.CoordinatorMap;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class GetCoordinatorMapResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private Location tsoLeaderLocation;

    private List<Location> coordinatorLocations;

    private CoordinatorMap coordinatorMap;

    private Location kvLeaderLocation;

    private long epoch;

    private Location autoIncrementLeaderLocation;

    private Location leaderLocation;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(3, epoch, out);
        Writer.write(4, leaderLocation, out);
        Writer.write(5, kvLeaderLocation, out);
        Writer.write(6, tsoLeaderLocation, out);
        Writer.write(7, autoIncrementLeaderLocation, out);
        Writer.write(8, coordinatorLocations, (n, v) -> Writer.write(n, v, out));
        Writer.write(9, coordinatorMap, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 3: epoch = Reader.readLong(input); hasValue = true; break;
                case 4: leaderLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : leaderLocation != null; break;
                case 5: kvLeaderLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : kvLeaderLocation != null; break;
                case 6: tsoLeaderLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : tsoLeaderLocation != null; break;
                case 7: autoIncrementLeaderLocation = Reader.readMessage(new Location(), input); hasValue = hasValue ? hasValue : autoIncrementLeaderLocation != null; break;
                case 8: coordinatorLocations = Reader.readList(coordinatorLocations, input, in -> Reader.readMessage(new Location(), in)); hasValue = true; break;
                case 9: coordinatorMap = Reader.readMessage(new CoordinatorMap(), input); hasValue = hasValue ? hasValue : coordinatorMap != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(3, epoch);
        size += SizeUtils.sizeOf(4, leaderLocation);
        size += SizeUtils.sizeOf(5, kvLeaderLocation);
        size += SizeUtils.sizeOf(6, tsoLeaderLocation);
        size += SizeUtils.sizeOf(7, autoIncrementLeaderLocation);
        size += SizeUtils.sizeOf(8, coordinatorLocations, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(9, coordinatorMap);
        return size;
    }
}
