package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Range;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class DeleteDataRequest implements Message {
    private List<String> txnCfNames;

    private Range range;

    private List<String> rawCfNames;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, range, out);
        Writer.write(2, rawCfNames, (n, v) -> Writer.write(n, v, out));
        Writer.write(3, txnCfNames, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 2: rawCfNames = Reader.readList(rawCfNames, input, Reader::readString); hasValue = true; break;
                case 3: txnCfNames = Reader.readList(txnCfNames, input, Reader::readString); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, range);
        size += SizeUtils.sizeOf(2, rawCfNames, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(3, txnCfNames, SizeUtils::sizeOf);
        return size;
    }
}
