package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RegionDefinition;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateRequest implements Message {
    private RegionDefinition regionDefinition;

    private long splitFromRegionId;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, regionDefinition, out);
        Writer.write(2, splitFromRegionId, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: regionDefinition = Reader.readMessage(new RegionDefinition(), input); hasValue = hasValue ? hasValue : regionDefinition != null; break;
                case 2: splitFromRegionId = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, regionDefinition);
        size += SizeUtils.sizeOf(2, splitFromRegionId);
        return size;
    }
}
