package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RawEngine;
import io.dingodb.sdk.service.entity.common.RegionType;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.StorageEngine;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CreateRegionRequest implements Message, Message.Request {
    private StorageEngine storeEngine;

    private long tenantId;

    private long partId;

    private String regionName;

    private String resourceTag;

    private long tableId;

    private RequestInfo requestInfo;

    private long regionId;

    private long splitFromRegionId;

    private boolean useRegionNameDirect;

    private long schemaId;

    private IndexParameter indexParameter;

    private long indexId;

    private RegionType regionType;

    private Range range;

    private long replicaNum;

    private RawEngine rawEngine;

    private List<Long> storeIds;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, requestInfo, out);
        Writer.write(2, regionName, out);
        Writer.write(3, resourceTag, out);
        Writer.write(4, replicaNum, out);
        Writer.write(5, range, out);
        Writer.write(6, rawEngine, out);
        Writer.write(7, storeEngine, out);
        Writer.write(8, regionId, out);
        Writer.write(9, useRegionNameDirect, out);
        Writer.write(11, schemaId, out);
        Writer.write(12, tableId, out);
        Writer.write(13, indexId, out);
        Writer.write(14, partId, out);
        Writer.write(15, tenantId, out);
        Writer.write(20, storeIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write(25, splitFromRegionId, out);
        Writer.write(30, regionType, out);
        Writer.write(40, indexParameter, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: requestInfo = Reader.readMessage(new RequestInfo(), input); hasValue = hasValue ? hasValue : requestInfo != null; break;
                case 2: regionName = Reader.readString(input); hasValue = true; break;
                case 3: resourceTag = Reader.readString(input); hasValue = true; break;
                case 4: replicaNum = Reader.readLong(input); hasValue = true; break;
                case 5: range = Reader.readMessage(new Range(), input); hasValue = hasValue ? hasValue : range != null; break;
                case 6: rawEngine = RawEngine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 7: storeEngine = StorageEngine.forNumber(Reader.readInt(input));hasValue = true; break;
                case 8: regionId = Reader.readLong(input); hasValue = true; break;
                case 9: useRegionNameDirect = Reader.readBoolean(input); hasValue = true; break;
                case 11: schemaId = Reader.readLong(input); hasValue = true; break;
                case 12: tableId = Reader.readLong(input); hasValue = true; break;
                case 13: indexId = Reader.readLong(input); hasValue = true; break;
                case 14: partId = Reader.readLong(input); hasValue = true; break;
                case 15: tenantId = Reader.readLong(input); hasValue = true; break;
                case 20: storeIds = Reader.readPack(input, Reader::readLong); hasValue = true; break;
                case 25: splitFromRegionId = Reader.readLong(input); hasValue = true; break;
                case 30: regionType = RegionType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 40: indexParameter = Reader.readMessage(new IndexParameter(), input); hasValue = hasValue ? hasValue : indexParameter != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, requestInfo);
        size += SizeUtils.sizeOf(2, regionName);
        size += SizeUtils.sizeOf(3, resourceTag);
        size += SizeUtils.sizeOf(4, replicaNum);
        size += SizeUtils.sizeOf(5, range);
        size += SizeUtils.sizeOf(6, rawEngine);
        size += SizeUtils.sizeOf(7, storeEngine);
        size += SizeUtils.sizeOf(8, regionId);
        size += SizeUtils.sizeOf(9, useRegionNameDirect);
        size += SizeUtils.sizeOf(11, schemaId);
        size += SizeUtils.sizeOf(12, tableId);
        size += SizeUtils.sizeOf(13, indexId);
        size += SizeUtils.sizeOf(14, partId);
        size += SizeUtils.sizeOf(15, tenantId);
        size += SizeUtils.sizeOfPack(20, storeIds, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(25, splitFromRegionId);
        size += SizeUtils.sizeOf(30, regionType);
        size += SizeUtils.sizeOf(40, indexParameter);
        return size;
    }
}
