package io.dingodb.sdk.service.entity.coordinator;

import io.dingodb.sdk.service.entity.Numeric;

public enum CoordinatorOperationType implements Numeric {
    UNRECOGNIZED(-1),

    COORDINATOR_OP_TYPE_NONE(0),

    COORDINATOR_OP_TYPE_DROP_REGION(1);

    public final Integer number;

    private Object ext$;

    private CoordinatorOperationType(Integer number) {
        this.number = number;
    }

    @Override
    public int number() {
        return number;
    }

    public static CoordinatorOperationType forNumber(int number) {
        switch(number) {
            case -1: return UNRECOGNIZED;
            case 0: return COORDINATOR_OP_TYPE_NONE;
            case 1: return COORDINATOR_OP_TYPE_DROP_REGION;
            default: return null;
        }
    }
}
