package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CoordinatorOperation implements Message {
    private CoordinatorOperationType coordinatorOpType;

    private OperationNest operation;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, coordinatorOpType, out);
        Writer.write(operation, operation, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: coordinatorOpType = CoordinatorOperationType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: operation = Reader.readMessage(new OperationNest.DropRegionOperation(), input); hasValue = hasValue ? hasValue : operation != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, coordinatorOpType);
        size += SizeUtils.sizeOf(operation, operation);
        return size;
    }

    public interface OperationNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class DropRegionOperation extends CoordinatorDropRegionOperation implements OperationNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.DROP_REGION_OPERATION;
            }
        }

        enum Nest implements Numeric {
            DROP_REGION_OPERATION(2);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
