package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.KeyValue;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class CoordinatorMemoryInfo implements Message {
    private long regionCmdMapSize;

    private long kvRevMapCount;

    private long idEpochMapCount;

    private long deletedTableMapSize;

    private long storeRegionMetricsMapSize;

    private long deletedRegionMapCount;

    private long kvLeaseMapSize;

    private long regionMapSize;

    private long kvLeaseMapCount;

    private long storeMetricsMapSize;

    private long executorMapCount;

    private long tableMetricsMapCount;

    private long indexMapCount;

    private long tenantMapCount;

    private long indexMetricsMapSize;

    private long storeMapSize;

    private long deletedTableMapCount;

    private long tableMapCount;

    private long storeOperationMapCount;

    private long coordinatorMapCount;

    private long autoIncrementMapCount;

    private long kvIndexMapCount;

    private long regionMapCount;

    private long tenantMapSize;

    private long totalSize;

    private long storeMapCount;

    private long storeMetricsMapCount;

    private long metaWatchCount;

    private long executorMapSize;

    private long tableMetricsMapSize;

    private long commonDiskMapCount;

    private long coordinatorMapSize;

    private long tableIndexMapSize;

    private long kvWatchCount;

    private long executorUserMapCount;

    private long tableIndexMapCount;

    private long kvIndexMapSize;

    private long storeRegionMetricsMapCount;

    private long commonMemMapSize;

    private long schemaMapCount;

    private long idEpochMapSize;

    private long idEpochSafeMapTempCount;

    private long autoIncrementMapSize;

    private long indexMapSize;

    private long regionMetricsMapCount;

    private long deletedRegionMapSize;

    private long deletedIndexMapCount;

    private long idEpochSafeMapTempSize;

    private long regionCmdMapCount;

    private long jobMapCount;

    private long executorUserMapSize;

    private long tableMapSize;

    private long rangeRegionMapCount;

    private List<KeyValue> idEpochValues;

    private long kvRevMapSize;

    private long regionMetricsMapSize;

    private long appliedIndex;

    private long commonMemMapCount;

    private long rangeRegionMapSize;

    private long commonDiskMapSize;

    private long storeOperationMapSize;

    private long jobMapSize;

    private long deletedIndexMapSize;

    private long metaEventCount;

    private long appliedTerm;

    private long indexMetricsMapCount;

    private long schemaMapSize;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, appliedTerm, out);
        Writer.write(2, appliedIndex, out);
        Writer.write(3, totalSize, out);
        Writer.write(4, idEpochSafeMapTempCount, out);
        Writer.write(5, idEpochSafeMapTempSize, out);
        Writer.write(6, idEpochMapCount, out);
        Writer.write(7, idEpochMapSize, out);
        Writer.write(8, coordinatorMapCount, out);
        Writer.write(9, coordinatorMapSize, out);
        Writer.write(10, storeMapCount, out);
        Writer.write(11, storeMapSize, out);
        Writer.write(12, executorMapCount, out);
        Writer.write(13, executorMapSize, out);
        Writer.write(14, executorUserMapCount, out);
        Writer.write(15, executorUserMapSize, out);
        Writer.write(21, schemaMapCount, out);
        Writer.write(22, schemaMapSize, out);
        Writer.write(23, regionMapCount, out);
        Writer.write(24, regionMapSize, out);
        Writer.write(25, rangeRegionMapCount, out);
        Writer.write(26, rangeRegionMapSize, out);
        Writer.write(27, tableMapCount, out);
        Writer.write(28, tableMapSize, out);
        Writer.write(29, indexMapCount, out);
        Writer.write(30, indexMapSize, out);
        Writer.write(41, storeMetricsMapCount, out);
        Writer.write(42, storeMetricsMapSize, out);
        Writer.write(43, tableMetricsMapCount, out);
        Writer.write(44, tableMetricsMapSize, out);
        Writer.write(48, indexMetricsMapCount, out);
        Writer.write(49, indexMetricsMapSize, out);
        Writer.write(50, regionMetricsMapCount, out);
        Writer.write(51, regionMetricsMapSize, out);
        Writer.write(52, storeRegionMetricsMapCount, out);
        Writer.write(53, storeRegionMetricsMapSize, out);
        Writer.write(61, storeOperationMapCount, out);
        Writer.write(62, storeOperationMapSize, out);
        Writer.write(63, regionCmdMapCount, out);
        Writer.write(64, regionCmdMapSize, out);
        Writer.write(65, jobMapCount, out);
        Writer.write(66, jobMapSize, out);
        Writer.write(71, deletedRegionMapCount, out);
        Writer.write(72, deletedRegionMapSize, out);
        Writer.write(73, deletedTableMapCount, out);
        Writer.write(74, deletedTableMapSize, out);
        Writer.write(75, deletedIndexMapCount, out);
        Writer.write(76, deletedIndexMapSize, out);
        Writer.write(77, tableIndexMapCount, out);
        Writer.write(78, tableIndexMapSize, out);
        Writer.write(79, commonDiskMapCount, out);
        Writer.write(80, commonDiskMapSize, out);
        Writer.write(81, commonMemMapCount, out);
        Writer.write(82, commonMemMapSize, out);
        Writer.write(83, tenantMapCount, out);
        Writer.write(84, tenantMapSize, out);
        Writer.write(91, kvLeaseMapCount, out);
        Writer.write(92, kvLeaseMapSize, out);
        Writer.write(93, kvIndexMapCount, out);
        Writer.write(94, kvIndexMapSize, out);
        Writer.write(95, kvRevMapCount, out);
        Writer.write(96, kvRevMapSize, out);
        Writer.write(97, kvWatchCount, out);
        Writer.write(100, idEpochValues, (n, v) -> Writer.write(n, v, out));
        Writer.write(101, metaWatchCount, out);
        Writer.write(102, metaEventCount, out);
        Writer.write(111, autoIncrementMapCount, out);
        Writer.write(112, autoIncrementMapSize, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: appliedTerm = Reader.readLong(input); hasValue = true; break;
                case 2: appliedIndex = Reader.readLong(input); hasValue = true; break;
                case 3: totalSize = Reader.readLong(input); hasValue = true; break;
                case 4: idEpochSafeMapTempCount = Reader.readLong(input); hasValue = true; break;
                case 5: idEpochSafeMapTempSize = Reader.readLong(input); hasValue = true; break;
                case 6: idEpochMapCount = Reader.readLong(input); hasValue = true; break;
                case 7: idEpochMapSize = Reader.readLong(input); hasValue = true; break;
                case 8: coordinatorMapCount = Reader.readLong(input); hasValue = true; break;
                case 9: coordinatorMapSize = Reader.readLong(input); hasValue = true; break;
                case 10: storeMapCount = Reader.readLong(input); hasValue = true; break;
                case 11: storeMapSize = Reader.readLong(input); hasValue = true; break;
                case 12: executorMapCount = Reader.readLong(input); hasValue = true; break;
                case 13: executorMapSize = Reader.readLong(input); hasValue = true; break;
                case 14: executorUserMapCount = Reader.readLong(input); hasValue = true; break;
                case 15: executorUserMapSize = Reader.readLong(input); hasValue = true; break;
                case 21: schemaMapCount = Reader.readLong(input); hasValue = true; break;
                case 22: schemaMapSize = Reader.readLong(input); hasValue = true; break;
                case 23: regionMapCount = Reader.readLong(input); hasValue = true; break;
                case 24: regionMapSize = Reader.readLong(input); hasValue = true; break;
                case 25: rangeRegionMapCount = Reader.readLong(input); hasValue = true; break;
                case 26: rangeRegionMapSize = Reader.readLong(input); hasValue = true; break;
                case 27: tableMapCount = Reader.readLong(input); hasValue = true; break;
                case 28: tableMapSize = Reader.readLong(input); hasValue = true; break;
                case 29: indexMapCount = Reader.readLong(input); hasValue = true; break;
                case 30: indexMapSize = Reader.readLong(input); hasValue = true; break;
                case 41: storeMetricsMapCount = Reader.readLong(input); hasValue = true; break;
                case 42: storeMetricsMapSize = Reader.readLong(input); hasValue = true; break;
                case 43: tableMetricsMapCount = Reader.readLong(input); hasValue = true; break;
                case 44: tableMetricsMapSize = Reader.readLong(input); hasValue = true; break;
                case 48: indexMetricsMapCount = Reader.readLong(input); hasValue = true; break;
                case 49: indexMetricsMapSize = Reader.readLong(input); hasValue = true; break;
                case 50: regionMetricsMapCount = Reader.readLong(input); hasValue = true; break;
                case 51: regionMetricsMapSize = Reader.readLong(input); hasValue = true; break;
                case 52: storeRegionMetricsMapCount = Reader.readLong(input); hasValue = true; break;
                case 53: storeRegionMetricsMapSize = Reader.readLong(input); hasValue = true; break;
                case 61: storeOperationMapCount = Reader.readLong(input); hasValue = true; break;
                case 62: storeOperationMapSize = Reader.readLong(input); hasValue = true; break;
                case 63: regionCmdMapCount = Reader.readLong(input); hasValue = true; break;
                case 64: regionCmdMapSize = Reader.readLong(input); hasValue = true; break;
                case 65: jobMapCount = Reader.readLong(input); hasValue = true; break;
                case 66: jobMapSize = Reader.readLong(input); hasValue = true; break;
                case 71: deletedRegionMapCount = Reader.readLong(input); hasValue = true; break;
                case 72: deletedRegionMapSize = Reader.readLong(input); hasValue = true; break;
                case 73: deletedTableMapCount = Reader.readLong(input); hasValue = true; break;
                case 74: deletedTableMapSize = Reader.readLong(input); hasValue = true; break;
                case 75: deletedIndexMapCount = Reader.readLong(input); hasValue = true; break;
                case 76: deletedIndexMapSize = Reader.readLong(input); hasValue = true; break;
                case 77: tableIndexMapCount = Reader.readLong(input); hasValue = true; break;
                case 78: tableIndexMapSize = Reader.readLong(input); hasValue = true; break;
                case 79: commonDiskMapCount = Reader.readLong(input); hasValue = true; break;
                case 80: commonDiskMapSize = Reader.readLong(input); hasValue = true; break;
                case 81: commonMemMapCount = Reader.readLong(input); hasValue = true; break;
                case 82: commonMemMapSize = Reader.readLong(input); hasValue = true; break;
                case 83: tenantMapCount = Reader.readLong(input); hasValue = true; break;
                case 84: tenantMapSize = Reader.readLong(input); hasValue = true; break;
                case 91: kvLeaseMapCount = Reader.readLong(input); hasValue = true; break;
                case 92: kvLeaseMapSize = Reader.readLong(input); hasValue = true; break;
                case 93: kvIndexMapCount = Reader.readLong(input); hasValue = true; break;
                case 94: kvIndexMapSize = Reader.readLong(input); hasValue = true; break;
                case 95: kvRevMapCount = Reader.readLong(input); hasValue = true; break;
                case 96: kvRevMapSize = Reader.readLong(input); hasValue = true; break;
                case 97: kvWatchCount = Reader.readLong(input); hasValue = true; break;
                case 100: idEpochValues = Reader.readList(idEpochValues, input, in -> Reader.readMessage(new KeyValue(), in)); hasValue = true; break;
                case 101: metaWatchCount = Reader.readLong(input); hasValue = true; break;
                case 102: metaEventCount = Reader.readLong(input); hasValue = true; break;
                case 111: autoIncrementMapCount = Reader.readLong(input); hasValue = true; break;
                case 112: autoIncrementMapSize = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, appliedTerm);
        size += SizeUtils.sizeOf(2, appliedIndex);
        size += SizeUtils.sizeOf(3, totalSize);
        size += SizeUtils.sizeOf(4, idEpochSafeMapTempCount);
        size += SizeUtils.sizeOf(5, idEpochSafeMapTempSize);
        size += SizeUtils.sizeOf(6, idEpochMapCount);
        size += SizeUtils.sizeOf(7, idEpochMapSize);
        size += SizeUtils.sizeOf(8, coordinatorMapCount);
        size += SizeUtils.sizeOf(9, coordinatorMapSize);
        size += SizeUtils.sizeOf(10, storeMapCount);
        size += SizeUtils.sizeOf(11, storeMapSize);
        size += SizeUtils.sizeOf(12, executorMapCount);
        size += SizeUtils.sizeOf(13, executorMapSize);
        size += SizeUtils.sizeOf(14, executorUserMapCount);
        size += SizeUtils.sizeOf(15, executorUserMapSize);
        size += SizeUtils.sizeOf(21, schemaMapCount);
        size += SizeUtils.sizeOf(22, schemaMapSize);
        size += SizeUtils.sizeOf(23, regionMapCount);
        size += SizeUtils.sizeOf(24, regionMapSize);
        size += SizeUtils.sizeOf(25, rangeRegionMapCount);
        size += SizeUtils.sizeOf(26, rangeRegionMapSize);
        size += SizeUtils.sizeOf(27, tableMapCount);
        size += SizeUtils.sizeOf(28, tableMapSize);
        size += SizeUtils.sizeOf(29, indexMapCount);
        size += SizeUtils.sizeOf(30, indexMapSize);
        size += SizeUtils.sizeOf(41, storeMetricsMapCount);
        size += SizeUtils.sizeOf(42, storeMetricsMapSize);
        size += SizeUtils.sizeOf(43, tableMetricsMapCount);
        size += SizeUtils.sizeOf(44, tableMetricsMapSize);
        size += SizeUtils.sizeOf(48, indexMetricsMapCount);
        size += SizeUtils.sizeOf(49, indexMetricsMapSize);
        size += SizeUtils.sizeOf(50, regionMetricsMapCount);
        size += SizeUtils.sizeOf(51, regionMetricsMapSize);
        size += SizeUtils.sizeOf(52, storeRegionMetricsMapCount);
        size += SizeUtils.sizeOf(53, storeRegionMetricsMapSize);
        size += SizeUtils.sizeOf(61, storeOperationMapCount);
        size += SizeUtils.sizeOf(62, storeOperationMapSize);
        size += SizeUtils.sizeOf(63, regionCmdMapCount);
        size += SizeUtils.sizeOf(64, regionCmdMapSize);
        size += SizeUtils.sizeOf(65, jobMapCount);
        size += SizeUtils.sizeOf(66, jobMapSize);
        size += SizeUtils.sizeOf(71, deletedRegionMapCount);
        size += SizeUtils.sizeOf(72, deletedRegionMapSize);
        size += SizeUtils.sizeOf(73, deletedTableMapCount);
        size += SizeUtils.sizeOf(74, deletedTableMapSize);
        size += SizeUtils.sizeOf(75, deletedIndexMapCount);
        size += SizeUtils.sizeOf(76, deletedIndexMapSize);
        size += SizeUtils.sizeOf(77, tableIndexMapCount);
        size += SizeUtils.sizeOf(78, tableIndexMapSize);
        size += SizeUtils.sizeOf(79, commonDiskMapCount);
        size += SizeUtils.sizeOf(80, commonDiskMapSize);
        size += SizeUtils.sizeOf(81, commonMemMapCount);
        size += SizeUtils.sizeOf(82, commonMemMapSize);
        size += SizeUtils.sizeOf(83, tenantMapCount);
        size += SizeUtils.sizeOf(84, tenantMapSize);
        size += SizeUtils.sizeOf(91, kvLeaseMapCount);
        size += SizeUtils.sizeOf(92, kvLeaseMapSize);
        size += SizeUtils.sizeOf(93, kvIndexMapCount);
        size += SizeUtils.sizeOf(94, kvIndexMapSize);
        size += SizeUtils.sizeOf(95, kvRevMapCount);
        size += SizeUtils.sizeOf(96, kvRevMapSize);
        size += SizeUtils.sizeOf(97, kvWatchCount);
        size += SizeUtils.sizeOf(100, idEpochValues, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(101, metaWatchCount);
        size += SizeUtils.sizeOf(102, metaEventCount);
        size += SizeUtils.sizeOf(111, autoIncrementMapCount);
        size += SizeUtils.sizeOf(112, autoIncrementMapSize);
        return size;
    }
}
