package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class ClusterState implements Message {
    private boolean clusterIsForceReadOnly;

    private String clusterReadOnlyReason;

    private boolean clusterIsReadOnly;

    private String clusterForceReadOnlyReason;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, clusterIsReadOnly, out);
        Writer.write(2, clusterIsForceReadOnly, out);
        Writer.write(3, clusterReadOnlyReason, out);
        Writer.write(4, clusterForceReadOnlyReason, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: clusterIsReadOnly = Reader.readBoolean(input); hasValue = true; break;
                case 2: clusterIsForceReadOnly = Reader.readBoolean(input); hasValue = true; break;
                case 3: clusterReadOnlyReason = Reader.readString(input); hasValue = true; break;
                case 4: clusterForceReadOnlyReason = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, clusterIsReadOnly);
        size += SizeUtils.sizeOf(2, clusterIsForceReadOnly);
        size += SizeUtils.sizeOf(3, clusterReadOnlyReason);
        size += SizeUtils.sizeOf(4, clusterForceReadOnlyReason);
        return size;
    }
}
