package io.dingodb.sdk.service.entity.coordinator;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class BalanceLeaderResponse implements Message, Message.Response {
    private Error error;

    private ResponseInfo responseInfo;

    private String expectLeaderScore;

    private String leaderScore;

    private List<TransferLeaderTask> tasks;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, responseInfo, out);
        Writer.write(2, error, out);
        Writer.write(10, leaderScore, out);
        Writer.write(11, expectLeaderScore, out);
        Writer.write(12, tasks, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: responseInfo = Reader.readMessage(new ResponseInfo(), input); hasValue = hasValue ? hasValue : responseInfo != null; break;
                case 2: error = Reader.readMessage(new Error(), input); hasValue = hasValue ? hasValue : error != null; break;
                case 10: leaderScore = Reader.readString(input); hasValue = true; break;
                case 11: expectLeaderScore = Reader.readString(input); hasValue = true; break;
                case 12: tasks = Reader.readList(tasks, input, in -> Reader.readMessage(new TransferLeaderTask(), in)); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, responseInfo);
        size += SizeUtils.sizeOf(2, error);
        size += SizeUtils.sizeOf(10, leaderScore);
        size += SizeUtils.sizeOf(11, expectLeaderScore);
        size += SizeUtils.sizeOf(12, tasks, SizeUtils::sizeOf);
        return size;
    }
}
