package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VersionInfo implements Message {
    private String gitTagName;

    private boolean useTcmalloc;

    private String gitCommitHash;

    private String dingoContribBuildType;

    private String dingoBuildType;

    private String gitCommitTime;

    private boolean useDiskann;

    private boolean useMkl;

    private String minorVersion;

    private boolean useProfiler;

    private String gitCommitMail;

    private boolean useOpenblas;

    private String gitCommitUser;

    private String majorVersion;

    private boolean diskannDependOnSystem;

    private boolean useSanitizer;

    private String boostSummary;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(10, gitCommitHash, out);
        Writer.write(20, gitTagName, out);
        Writer.write(21, gitCommitUser, out);
        Writer.write(22, gitCommitMail, out);
        Writer.write(23, gitCommitTime, out);
        Writer.write(30, majorVersion, out);
        Writer.write(40, minorVersion, out);
        Writer.write(50, dingoBuildType, out);
        Writer.write(60, dingoContribBuildType, out);
        Writer.write(70, useMkl, out);
        Writer.write(80, useOpenblas, out);
        Writer.write(90, useTcmalloc, out);
        Writer.write(100, useProfiler, out);
        Writer.write(110, useSanitizer, out);
        Writer.write(120, useDiskann, out);
        Writer.write(130, diskannDependOnSystem, out);
        Writer.write(140, boostSummary, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 10: gitCommitHash = Reader.readString(input); hasValue = true; break;
                case 20: gitTagName = Reader.readString(input); hasValue = true; break;
                case 21: gitCommitUser = Reader.readString(input); hasValue = true; break;
                case 22: gitCommitMail = Reader.readString(input); hasValue = true; break;
                case 23: gitCommitTime = Reader.readString(input); hasValue = true; break;
                case 30: majorVersion = Reader.readString(input); hasValue = true; break;
                case 40: minorVersion = Reader.readString(input); hasValue = true; break;
                case 50: dingoBuildType = Reader.readString(input); hasValue = true; break;
                case 60: dingoContribBuildType = Reader.readString(input); hasValue = true; break;
                case 70: useMkl = Reader.readBoolean(input); hasValue = true; break;
                case 80: useOpenblas = Reader.readBoolean(input); hasValue = true; break;
                case 90: useTcmalloc = Reader.readBoolean(input); hasValue = true; break;
                case 100: useProfiler = Reader.readBoolean(input); hasValue = true; break;
                case 110: useSanitizer = Reader.readBoolean(input); hasValue = true; break;
                case 120: useDiskann = Reader.readBoolean(input); hasValue = true; break;
                case 130: diskannDependOnSystem = Reader.readBoolean(input); hasValue = true; break;
                case 140: boostSummary = Reader.readString(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(10, gitCommitHash);
        size += SizeUtils.sizeOf(20, gitTagName);
        size += SizeUtils.sizeOf(21, gitCommitUser);
        size += SizeUtils.sizeOf(22, gitCommitMail);
        size += SizeUtils.sizeOf(23, gitCommitTime);
        size += SizeUtils.sizeOf(30, majorVersion);
        size += SizeUtils.sizeOf(40, minorVersion);
        size += SizeUtils.sizeOf(50, dingoBuildType);
        size += SizeUtils.sizeOf(60, dingoContribBuildType);
        size += SizeUtils.sizeOf(70, useMkl);
        size += SizeUtils.sizeOf(80, useOpenblas);
        size += SizeUtils.sizeOf(90, useTcmalloc);
        size += SizeUtils.sizeOf(100, useProfiler);
        size += SizeUtils.sizeOf(110, useSanitizer);
        size += SizeUtils.sizeOf(120, useDiskann);
        size += SizeUtils.sizeOf(130, diskannDependOnSystem);
        size += SizeUtils.sizeOf(140, boostSummary);
        return size;
    }
}
