package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorWithId implements Message {
    private VectorTableData tableData;

    private long id;

    private VectorScalardata scalarData;

    private Vector vector;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, id, out);
        Writer.write(2, vector, out);
        Writer.write(3, scalarData, out);
        Writer.write(4, tableData, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: id = Reader.readLong(input); hasValue = true; break;
                case 2: vector = Reader.readMessage(new Vector(), input); hasValue = hasValue ? hasValue : vector != null; break;
                case 3: scalarData = Reader.readMessage(new VectorScalardata(), input); hasValue = hasValue ? hasValue : scalarData != null; break;
                case 4: tableData = Reader.readMessage(new VectorTableData(), input); hasValue = hasValue ? hasValue : tableData != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, id);
        size += SizeUtils.sizeOf(2, vector);
        size += SizeUtils.sizeOf(3, scalarData);
        size += SizeUtils.sizeOf(4, tableData);
        return size;
    }
}
