package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorWithDistance implements Message {
    private VectorWithId vectorWithId;

    private MetricType metricType;

    private float distance;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, vectorWithId, out);
        Writer.write(2, distance, out);
        Writer.write(3, metricType, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: vectorWithId = Reader.readMessage(new VectorWithId(), input); hasValue = hasValue ? hasValue : vectorWithId != null; break;
                case 2: distance = Reader.readFloat(input); hasValue = true; break;
                case 3: metricType = MetricType.forNumber(Reader.readInt(input));hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, vectorWithId);
        size += SizeUtils.sizeOf(2, distance);
        size += SizeUtils.sizeOf(3, metricType);
        return size;
    }
}
