package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorStateParameter implements Message {
    private StateNest state;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(state, state, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: state = Reader.readMessage(new StateNest.Flat(), input); hasValue = hasValue ? hasValue : state != null; break;
                case 2: state = Reader.readMessage(new StateNest.IvfFlat(), input); hasValue = hasValue ? hasValue : state != null; break;
                case 3: state = Reader.readMessage(new StateNest.IvfPq(), input); hasValue = hasValue ? hasValue : state != null; break;
                case 4: state = Reader.readMessage(new StateNest.Hnsw(), input); hasValue = hasValue ? hasValue : state != null; break;
                case 5: state = Reader.readMessage(new StateNest.Diskann(), input); hasValue = hasValue ? hasValue : state != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(state, state);
        return size;
    }

    public interface StateNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class Flat extends StateFlatParam implements StateNest {
            public static final int number = 1;

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfFlat extends StateIvfFlatParam implements StateNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfPq extends StateIvfPqParam implements StateNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Hnsw extends StateHNSWParam implements StateNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Diskann extends StateDiskAnnParam implements StateNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN;
            }
        }

        enum Nest implements Numeric {
            FLAT(1),

            IVF_FLAT(2),

            IVF_PQ(3),

            HNSW(4),

            DISKANN(5);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
