package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorLoadParameter implements Message {
    private LoadNest load;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(load, load, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: load = Reader.readMessage(new LoadNest.Flat(), input); hasValue = hasValue ? hasValue : load != null; break;
                case 2: load = Reader.readMessage(new LoadNest.IvfFlat(), input); hasValue = hasValue ? hasValue : load != null; break;
                case 3: load = Reader.readMessage(new LoadNest.IvfPq(), input); hasValue = hasValue ? hasValue : load != null; break;
                case 4: load = Reader.readMessage(new LoadNest.Hnsw(), input); hasValue = hasValue ? hasValue : load != null; break;
                case 5: load = Reader.readMessage(new LoadNest.Diskann(), input); hasValue = hasValue ? hasValue : load != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(load, load);
        return size;
    }

    public interface LoadNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class Flat extends LoadFlatParam implements LoadNest {
            public static final int number = 1;

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfFlat extends LoadIvfFlatParam implements LoadNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfPq extends LoadIvfPqParam implements LoadNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Hnsw extends LoadHNSWParam implements LoadNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Diskann extends LoadDiskAnnParam implements LoadNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN;
            }
        }

        enum Nest implements Numeric {
            FLAT(1),

            IVF_FLAT(2),

            IVF_PQ(3),

            HNSW(4),

            DISKANN(5);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
