package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorIndexParameter implements Message {
    private ScalarSchema scalarSchema;

    private VectorIndexType vectorIndexType;

    private VectorIndexParameterNest vectorIndexParameter;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, vectorIndexType, out);
        Writer.write(vectorIndexParameter, vectorIndexParameter, out);
        Writer.write(50, scalarSchema, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: vectorIndexType = VectorIndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.FlatParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 3: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.IvfFlatParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 4: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.IvfPqParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 5: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.HnswParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 6: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.DiskannParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 7: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.BruteforceParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 15: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.BinaryFlatParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 16: vectorIndexParameter = Reader.readMessage(new VectorIndexParameterNest.BinaryIvfFlatParameter(), input); hasValue = hasValue ? hasValue : vectorIndexParameter != null; break;
                case 50: scalarSchema = Reader.readMessage(new ScalarSchema(), input); hasValue = hasValue ? hasValue : scalarSchema != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, vectorIndexType);
        size += SizeUtils.sizeOf(vectorIndexParameter, vectorIndexParameter);
        size += SizeUtils.sizeOf(50, scalarSchema);
        return size;
    }

    public interface VectorIndexParameterNest extends Message, Numeric {
        int number();

        Nest nest();

        int getDimension();

        MetricType getMetricType();

        @NoArgsConstructor
        @SuperBuilder
        class FlatParameter extends CreateFlatParam implements VectorIndexParameterNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfFlatParameter extends CreateIvfFlatParam implements VectorIndexParameterNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfPqParameter extends CreateIvfPqParam implements VectorIndexParameterNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class HnswParameter extends CreateHnswParam implements VectorIndexParameterNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class DiskannParameter extends CreateDiskAnnParam implements VectorIndexParameterNest {
            public static final int number = 6;

            @Override
            public int number() {
                return 6;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class BruteforceParameter extends CreateBruteForceParam implements VectorIndexParameterNest {
            public static final int number = 7;

            @Override
            public int number() {
                return 7;
            }

            @Override
            public Nest nest() {
                return Nest.BRUTEFORCE_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class BinaryFlatParameter extends CreateBinaryFlatParam implements VectorIndexParameterNest {
            public static final int number = 15;

            @Override
            public int number() {
                return 15;
            }

            @Override
            public Nest nest() {
                return Nest.BINARY_FLAT_PARAMETER;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class BinaryIvfFlatParameter extends CreateBinaryIvfFlatParam implements VectorIndexParameterNest {
            public static final int number = 16;

            @Override
            public int number() {
                return 16;
            }

            @Override
            public Nest nest() {
                return Nest.BINARY_IVF_FLAT_PARAMETER;
            }
        }

        enum Nest implements Numeric {
            FLAT_PARAMETER(2),

            IVF_FLAT_PARAMETER(3),

            IVF_PQ_PARAMETER(4),

            HNSW_PARAMETER(5),

            DISKANN_PARAMETER(6),

            BRUTEFORCE_PARAMETER(7),

            BINARY_FLAT_PARAMETER(15),

            BINARY_IVF_FLAT_PARAMETER(16);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
