package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorIndexMetrics implements Message {
    private long deletedCount;

    private long minId;

    private long currentCount;

    private long maxId;

    private VectorIndexType vectorIndexType;

    private long memoryBytes;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(1, vectorIndexType, out);
        Writer.write(2, currentCount, out);
        Writer.write(3, deletedCount, out);
        Writer.write(4, maxId, out);
        Writer.write(5, minId, out);
        Writer.write(6, memoryBytes, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: vectorIndexType = VectorIndexType.forNumber(Reader.readInt(input));hasValue = true; break;
                case 2: currentCount = Reader.readLong(input); hasValue = true; break;
                case 3: deletedCount = Reader.readLong(input); hasValue = true; break;
                case 4: maxId = Reader.readLong(input); hasValue = true; break;
                case 5: minId = Reader.readLong(input); hasValue = true; break;
                case 6: memoryBytes = Reader.readLong(input); hasValue = true; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, vectorIndexType);
        size += SizeUtils.sizeOf(2, currentCount);
        size += SizeUtils.sizeOf(3, deletedCount);
        size += SizeUtils.sizeOf(4, maxId);
        size += SizeUtils.sizeOf(5, minId);
        size += SizeUtils.sizeOf(6, memoryBytes);
        return size;
    }
}
