package io.dingodb.sdk.service.entity.common;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.Numeric;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.FieldNameConstants;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@FieldNameConstants
public class VectorBuildParameter implements Message {
    private BuildNest build;

    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write(build, build, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        while((number = Reader.readNumber(input)) != 0) {
            switch(number) {
                case 1: build = Reader.readMessage(new BuildNest.Flat(), input); hasValue = hasValue ? hasValue : build != null; break;
                case 2: build = Reader.readMessage(new BuildNest.IvfFlat(), input); hasValue = hasValue ? hasValue : build != null; break;
                case 3: build = Reader.readMessage(new BuildNest.IvfPq(), input); hasValue = hasValue ? hasValue : build != null; break;
                case 4: build = Reader.readMessage(new BuildNest.Hnsw(), input); hasValue = hasValue ? hasValue : build != null; break;
                case 5: build = Reader.readMessage(new BuildNest.Diskann(), input); hasValue = hasValue ? hasValue : build != null; break;
                default: Reader.skip(input);
            }
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(build, build);
        return size;
    }

    public interface BuildNest extends Message, Numeric {
        int number();

        Nest nest();

        @NoArgsConstructor
        @SuperBuilder
        class Flat extends BuildFlatParam implements BuildNest {
            public static final int number = 1;

            @Override
            public int number() {
                return 1;
            }

            @Override
            public Nest nest() {
                return Nest.FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfFlat extends BuildIvfFlatParam implements BuildNest {
            public static final int number = 2;

            @Override
            public int number() {
                return 2;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_FLAT;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class IvfPq extends BuildIvfPqParam implements BuildNest {
            public static final int number = 3;

            @Override
            public int number() {
                return 3;
            }

            @Override
            public Nest nest() {
                return Nest.IVF_PQ;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Hnsw extends BuildHNSWParam implements BuildNest {
            public static final int number = 4;

            @Override
            public int number() {
                return 4;
            }

            @Override
            public Nest nest() {
                return Nest.HNSW;
            }
        }

        @NoArgsConstructor
        @SuperBuilder
        class Diskann extends BuildDiskAnnParam implements BuildNest {
            public static final int number = 5;

            @Override
            public int number() {
                return 5;
            }

            @Override
            public Nest nest() {
                return Nest.DISKANN;
            }
        }

        enum Nest implements Numeric {
            FLAT(1),

            IVF_FLAT(2),

            IVF_PQ(3),

            HNSW(4),

            DISKANN(5);

            public final Integer number;

            private Nest(Integer number) {
                this.number = number;
            }

            @Override
            public int number() {
                return number;
            }
        }
    }
}
